
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Jul 30 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version KMNG_Ext_ATP_TestVectors.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "KMNG_Ext_ATP_Acceptance.h"
#include "CRYS_DH.h"


/************************ Defines *******************************/

/* canceling the lint warning:
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */

/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/


TST_Ext_KeysSym_TestDataStruct SEP_AES_KeysOpSym_TestData[] = 
{
	{
		{"Acceptance test - AES/ECB/128Key"},
			/*TST_Pwd*/
		{0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
		/*TST_PwdLen*/
		10,
		/*TST_KeyPwd*/
		{0x1,0x2,0x3,0x4},
		/*TST_KeyPwdLen*/
		4,
		/*TST_KeyID*/
		0,
		/*TST_KeyType*/
		KMNG_KeyTypeAES,
		/*TST_KeyUsage*/
		KMNG_KEY_USAGE_STORAGE,
		/*TST_KeyRestriction*/
		KMNG_KEY_RESTRICTION_EXPORTABLE,
		/*TST_key*/
		{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
		/*TST_KeySize*/
		16,
		/*TST_Exportedkey*/
		{0},
		/*TST_IV*/
		{0},
		/*TST_AESMode*/
		CRYS_AES_ECB_mode,
		/*TST_DESMode*/
		CRYS_DES_ECB_mode,
		/*TST_HASHMode*/
		CRYS_HASH_SHA1_mode,
		/*TST_Data*/
		{0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
		/*TST_DataLen*/
		16,
		/*TST_ExpectedOutput*/
		{0xdd,0xd3,0x44,0x6f,0xf2,0x86,0x42,0xaa,0x3c,0xa7,0x64,0xbc,0xe7,0x48,0x06,0xb5},
		/*TST_OutputData*/
		{0},
		/*TST_OutputLen*/
		16,
		TST_KMNG_VERIFY_OUTPUT,
		/*TST_UserData*/
		{0}
	}
};

TST_Ext_KeysSym_TestDataStruct SEP_DES_KeysOpSym_TestData[] = 
{
	  {
	    {"Acceptance test - DES/ECB/64Key"},
	      /*TST_Pwd*/
	    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	    /*TST_PwdLen*/
	    10,
	    /*TST_KeyPwd*/
	    {0x1,0x2,0x3,0x4},
	    /*TST_KeyPwdLen*/
	    4,
	    /*TST_KeyID*/
	    0,
	    /*TST_KeyType*/
	    KMNG_KeyTypeDES,
	    /*TST_KeyUsage*/
	    KMNG_KEY_USAGE_STORAGE,
	    /*TST_KeyRestriction*/
	    KMNG_KEY_RESTRICTION_EXPORTABLE,
	    /*TST_key*/
	    {0x3d,0x26,0xb2,0xa7,0xa9,0xf3,0x55,0xde},
	    /*TST_KeySize*/
	    8,
	    /*TST_Exportedkey*/
	    {0},
	    /*TST_IV*/
	    {0},
	    /*TST_AESMode*/
	    CRYS_AES_CTR_mode,
	    /*TST_DESMode*/
	    CRYS_DES_ECB_mode,
	    /*TST_HASHMode*/
	    CRYS_HASH_SHA1_mode,
	    /*TST_Data*/
	    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
	    /*TST_DataLen*/
	    16,
	    /*TST_ExpectedOutput*/
	    {0x9e,0x86,0xde,0xe2,0x0c,0x42,0x67,0x05,0x78,0xcb,0xc7,0xf2,0x82,0xdd,0x50,0x2d},
	    /*TST_OutputData*/
	    {0},
	    /*TST_OutputLen*/
	    16,
	    TST_KMNG_VERIFY_OUTPUT,
	    /*TST_UserData*/
	    {0}
	  }
};

TST_Ext_KeysSym_TestDataStruct SEP_HMAC_KeysOpSym_TestData[] = 
{
	  {
	    {"Acceptance test - HMAC/SHA1/160Key"},
	    /*TST_Pwd*/
	    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	    /*TST_PwdLen*/
	    10,
	    /*TST_KeyPwd*/
	    {0x1,0x2,0x3,0x4},
	    /*TST_KeyPwdLen*/
	    4,
	    /*TST_KeyID*/
	    0,
	    /*TST_KeyType*/
	    KMNG_KeyTypeHMAC,
	    /*TST_KeyUsage*/
	    KMNG_KEY_USAGE_SIGNING,
	    /*TST_KeyRestriction*/
	    KMNG_KEY_RESTRICTION_EXPORTABLE,
	    /*TST_key*/
	    {0x13,0x83,0x78,0x3f,0xaa,0x17,0xf4,0x60,0xc3,0x95,0x60,0xab,0x73,0x0f,0x95,0x65,
	     0x7d,0x8c,0x8c,0x71},
	     /*TST_KeySize*/
	     20,
	     /*TST_Exportedkey*/
	    {0},
	    /*TST_IV*/
	    {0},
	    /*TST_AESMode*/
	    CRYS_AES_ECB_mode,
	    /*TST_DESMode*/
	    CRYS_DES_CBC_mode,
	    /*TST_HASHMode*/
	    CRYS_HASH_SHA1_mode,
	    /*TST_Data*/
	    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
	    /*TST_DataLen*/
	    16,
	    /*TST_ExpectedOutput*/
	    {0x3f,0x53,0xf0,0x3e,0xcd,0xf0,0x08,0x73,0xe6,0x9c,0x8b,0x91,0x8c,0xad,0x29,0xc3,
	     0xa5,0x51,0xab,0x12},
	    /*TST_OutputData*/
	    {0},
	    /*TST_OutputLen*/
	    20,
	    TST_KMNG_VERIFY_OUTPUT,
	    /*TST_UserData*/
	    {0}
	  }
};

TST_Ext_KeysRSA_TestDataStruct SEP_KeysOpRSA_Ver15_TestData[] = 
{
	{
		{"Acceptance test - RSA PKCS1v15 1024bit"},
	    /*TST_Pwd*/
		{0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
		/*TST_PwdLen*/
		10,
		/*TST_KeyPwd*/
		{0x1,0x2,0x3,0x4},
		/*TST_KeyPwdLen*/
		4,
		/*TST_KeyID*/
		0,
		/*TST_KeyType*/
		KMNG_KeyTypeRSAPair,
		/*TST_KeyUsage*/
		KMNG_KEY_USAGE_SIGNING,
		/*TST_KeyRestriction*/
		KMNG_KEY_RESTRICTION_EXPORTABLE,
		/*TST_KeySize*/
		128,
		/*TST_PKCS1_ver*/
		CRYS_PKCS1_VER15,
		/*TST_HASHMode*/
		CRYS_RSA_HASH_SHA1_mode,
		/*TST_E*/
		{0x01,0x00,0x01},
		/*TST_ESize*/
		3,
		/*TST_ExportedE*/
		{0},
		/*TST_ExportedESize*/
		0,    
		/*TST_N*/
		{0xb7,0x33,0x08,0x1b,0x2d,0x70,0x31,0xd1,0xec,0x27,0x8b,0xb7,0x71,0x75,0x0e,0x63,
		0x97,0xef,0xd9,0x1f,0x36,0x49,0x36,0xb3,0x43,0xf4,0xbb,0x0a,0x9d,0x67,0xa8,0xc8,
		0x5a,0x1a,0x57,0xd5,0x5a,0x90,0x9e,0xed,0xad,0xc5,0x1d,0x0d,0x7a,0x66,0x30,0x61,
		0x6d,0xd2,0xef,0x6b,0xca,0xe2,0x21,0x09,0x9e,0xe4,0x2d,0xec,0x28,0x1e,0x27,0xbc,
		0xd3,0xf2,0xb3,0x01,0x44,0xc7,0x62,0x96,0xbe,0xf7,0x70,0x9e,0xdf,0xa3,0x02,0x3a,
		0x95,0x99,0x40,0x01,0x8c,0xf6,0xf6,0x88,0xe9,0xee,0x7d,0xea,0x51,0x1f,0x22,0xa5,
		0xd9,0xa7,0xfb,0x58,0x1d,0x77,0x21,0xc1,0x8e,0x0e,0xbc,0xd5,0xa0,0x87,0x99,0x36,
		0xcb,0x10,0xe8,0x08,0xf8,0x4d,0xd2,0xec,0xad,0x92,0x37,0x98,0x9a,0x32,0xdf,0x61},
		/*TST_NSize*/
		128,
		/*TST_ExportedN*/
		{0},
		/*TST_ExportedNSize*/
		0,    
		/*TST_D*/
		{0xb6,0xdb,0xba,0x20,0x9e,0x77,0x19,0x53,0x46,0x9b,0xa6,0x6a,0xc1,0x55,0xac,0xba,
		0x1e,0x22,0xea,0x9e,0xab,0xe9,0xe2,0x2e,0x87,0x0b,0x15,0x53,0x20,0x10,0x22,0xb9,
		0x70,0xae,0x50,0xb3,0x86,0x05,0x4a,0x8d,0x44,0xe0,0xb6,0x02,0x09,0x05,0x4d,0x0f,
		0x42,0xb6,0xc4,0x01,0xdc,0xed,0x5f,0x3a,0xa2,0x1d,0x71,0xf5,0x01,0x8a,0x2f,0xf0,
		0x2b,0x6f,0x33,0x2e,0x68,0xa6,0x40,0xb0,0x3f,0x66,0x7c,0xd0,0xe6,0x70,0x79,0x54,
		0x58,0x35,0x66,0x04,0x71,0xf8,0xc0,0x93,0x4b,0xe9,0x06,0x3b,0xf8,0xf2,0xe2,0x77,
		0x36,0xe0,0xfe,0x42,0x43,0x3c,0x3a,0x01,0x10,0xd2,0x6f,0xc1,0xb8,0x93,0x6e,0x03,
		0x60,0xaa,0x37,0x51,0x57,0x9a,0x8c,0xa8,0x9e,0x1b,0x10,0xab,0x43,0x88,0x83,0x51},
		/*TST_DSize*/
		128,
		/*TST_ExportedD*/
		{0},
		/*TST_ExportedDSize*/
		0,
		/*TST_Data*/
		{0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
		0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
		0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
		0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
		0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
		0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
		0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
		0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
		/*TST_DataLen*/
		128,
		/*TST_ExpectedOutput*/
		{0},
		/*TST_OutputLen*/
		0,
		TST_KMNG_DO_NOT_VERIFY_OUTPUT,
		/*TST_UserData*/
		{0}
	}
};

TST_Ext_KeysRSA_TestDataStruct SEP_KeysOpRSA_Ver21_TestData[] = 
{
	{
    {"Acceptance test - RSA PKCS1v21 1024bit"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER21,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xb7,0x33,0x08,0x1b,0x2d,0x70,0x31,0xd1,0xec,0x27,0x8b,0xb7,0x71,0x75,0x0e,0x63,
     0x97,0xef,0xd9,0x1f,0x36,0x49,0x36,0xb3,0x43,0xf4,0xbb,0x0a,0x9d,0x67,0xa8,0xc8,
     0x5a,0x1a,0x57,0xd5,0x5a,0x90,0x9e,0xed,0xad,0xc5,0x1d,0x0d,0x7a,0x66,0x30,0x61,
     0x6d,0xd2,0xef,0x6b,0xca,0xe2,0x21,0x09,0x9e,0xe4,0x2d,0xec,0x28,0x1e,0x27,0xbc,
     0xd3,0xf2,0xb3,0x01,0x44,0xc7,0x62,0x96,0xbe,0xf7,0x70,0x9e,0xdf,0xa3,0x02,0x3a,
     0x95,0x99,0x40,0x01,0x8c,0xf6,0xf6,0x88,0xe9,0xee,0x7d,0xea,0x51,0x1f,0x22,0xa5,
     0xd9,0xa7,0xfb,0x58,0x1d,0x77,0x21,0xc1,0x8e,0x0e,0xbc,0xd5,0xa0,0x87,0x99,0x36,
     0xcb,0x10,0xe8,0x08,0xf8,0x4d,0xd2,0xec,0xad,0x92,0x37,0x98,0x9a,0x32,0xdf,0x61},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0xb6,0xdb,0xba,0x20,0x9e,0x77,0x19,0x53,0x46,0x9b,0xa6,0x6a,0xc1,0x55,0xac,0xba,
     0x1e,0x22,0xea,0x9e,0xab,0xe9,0xe2,0x2e,0x87,0x0b,0x15,0x53,0x20,0x10,0x22,0xb9,
     0x70,0xae,0x50,0xb3,0x86,0x05,0x4a,0x8d,0x44,0xe0,0xb6,0x02,0x09,0x05,0x4d,0x0f,
     0x42,0xb6,0xc4,0x01,0xdc,0xed,0x5f,0x3a,0xa2,0x1d,0x71,0xf5,0x01,0x8a,0x2f,0xf0,
     0x2b,0x6f,0x33,0x2e,0x68,0xa6,0x40,0xb0,0x3f,0x66,0x7c,0xd0,0xe6,0x70,0x79,0x54,
     0x58,0x35,0x66,0x04,0x71,0xf8,0xc0,0x93,0x4b,0xe9,0x06,0x3b,0xf8,0xf2,0xe2,0x77,
     0x36,0xe0,0xfe,0x42,0x43,0x3c,0x3a,0x01,0x10,0xd2,0x6f,0xc1,0xb8,0x93,0x6e,0x03,
     0x60,0xaa,0x37,0x51,0x57,0x9a,0x8c,0xa8,0x9e,0x1b,0x10,0xab,0x43,0x88,0x83,0x51},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  }
};

/* Data for the DH tests */
TST_KeysDHData_TestDataStruct SEP_KeysDHData_TestData[] = 
{
	{
		/*TST_Name */
		{"Created 1024Bits DH key"},
			/*TST_Pwd*/
		{0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
		/*TST_PwdLen*/
		10,
		/*TST_KeyPwd*/
		{0x1,0x2,0x3,0x4},
		/*TST_KeyPwdLen*/
		4,
		/*TST_KeyID*/
		0,
		/*TST_KeyType*/
		KMNG_KeyTypeDH,
		/*TST_KeyUsage*/
		KMNG_KEY_USAGE_LEGACY,
		/*TST_KeyRestriction*/
		KMNG_KEY_RESTRICTION_EXPORTABLE,
		/*TST_KeySize*/
		128,
		/*TST_P */
		{0},
		/*TST_PSize */
		128,
		/*TST_ExportedP */
		{0},
		/*TST_ExportedPSize */
		0,
		/*TST_G */
		{0},
		/*TST_GSize */
		128,
		/*TST_ExportedG */
		{0},
		/*TST_ExportedGSize */
		0,
		/*TST_PubKey */
		{0},
		/*TST_PubKeySize */
		0,
		/*TST_ExportedPubKey */
		{0},
		/*TST_ExportedPubKeySize */
		0,
		/*TST_PrivateKey */
		{0},
		/*TST_PrivateKeySize */
		0,
		/*TST_ExportedPrivateKey */
		{0},
		/*TST_ExportedPrivateKeySize */
		0,
		/*TST_L */
		11,
		/*TST_SecretKey */
		{0},
		/*TST_ServerSecretKey */
		{0},
		/*TST_VerifyOutput */
		TST_KMNG_DO_NOT_VERIFY_OUTPUT,
		/*TST_UserData */
		{0}
	}
};



/************* Private function prototype ***********************/
/************************ Public Functions ******************************/
